implementation module DynID

import StdEnv, md5
import DynamicUtilities
import DynamicLinkerInterface

::DynamicID1 :== String

// obsolete(?) ...
createDynIDFromString :: String -> DynamicID1
createDynIDFromString szoveg=
	getMd5DigestFromString szoveg

createDynIDFromFile	:: String *World -> (DynamicID1,*World)
createDynIDFromFile fileName world=
	getMd5DigestFromFile fileName world

instance toString DynamicID1 where
	toString id = id

instance fromString DynamicID1 where
	fromString s = s
// ... obsolete(?)

// Applications used by dynamics
DS_DYNAMIC_LINKER		:== "DynamicLinker12.exe";

// Predefined directories (w.r.t. root-directory):
DS_LIBRARIES_DIR		:== "libraries"
DS_SYSTEM_DYNAMICS_DIR	:== "system dynamics"
DS_CONVERSION_DIR		:== "conversion"
DS_UTILITIES_DIR		:== "utilities"
DS_LOGS_DIR				:== "logs"

// The identification of a {type,code}-library is determined by the static linker which uses
// the CREATE_ENCODED_LIBRARY_FILE_NAME-macro to create an identification for a particular
// type/library-pair.
//
// Further the identification of a {user,system}-dynamic is determined by StdDynamicFileIO.
//
// Other tools than the creators of the identifications should respect the here established
// convention by using the macros provided below.
	
// IDS FOR DYNAMICS:
// encoded file_name:												<link_name>_<md5>
// run-time file_name:  	<DLINK PATH>\\<DS_SYSTEM_DYNAMICS_DIR>\\<link_name>_<md5>
CREATE_ENCODED_DYNAMIC_FILE_NAME link_name md5_dynamic_identification
	:== (NAME_PREFIXES (link_name +++ "_") "") +++ md5_dynamic_identification;
	
CONVERTED_ENCODED_DYNAMIC_FILE_NAME_INTO_PATH base_directory encoded_dynamic_file_name
	:== base_directory +++ "\\" +++ DS_SYSTEM_DYNAMICS_DIR +++ "\\" +++ encoded_dynamic_file_name +++ "." +++ EXTENSION_SYSTEM_DYNAMIC;
	
EXTENSION_SYSTEM_DYNAMIC
	:== "sysdyn"

// IDS FOR LIBRARIES
// encoded file_name:	<library name>_<md5 from code>_<md5 from type>
// run-time file_name:	<DLINK PATH>\\<DS_SYSTEM_DYNAMICS_DIR>\\<library name>_<md5 from code>_<md5 from type>.{typ,lib}
CREATE_ENCODED_LIBRARY_FILE_NAME library_name code_md5 type_md5
	:== (NAME_PREFIXES (library_name +++ "_") "") +++ code_md5 +++ "_" +++ type_md5;
	
CONVERT_ENCODED_LIBRARY_IDENTIFICATION_INTO_RUN_TIME_LIBRARY_IDENTIFICATION base_directory encoded_library_identification
	:== base_directory +++ "\\" +++ DS_LIBRARIES_DIR +++ "\\" +++ encoded_library_identification;

ADD_CODE_LIBRARY_EXTENSION library_identification
	:== library_identification +++ "." +++ EXTENSION_CODE_LIBRARY;
ADD_TYPE_LIBRARY_EXTENSION library_identification
	:== library_identification +++ "." +++ EXTENSION_TYPE_LIBRARY;
	
EXTENSION_CODE_LIBRARY
	:== "lib"
EXTENSION_TYPE_LIBRARY
	:== "typ"
	
extract_dynamic_or_library_identification :: !String -> String
extract_dynamic_or_library_identification file_name
	= (snd (ExtractPathAndFile (fst (ExtractPathFileAndExtension file_name))));
	
EXTENSION_USER_DYNAMIC
	:== "dyn"
	
get_system_dynamic_identification :: !String !*f -> (!Bool,!String,!*f) | FileSystem f
get_system_dynamic_identification file_name1 files
	| ends file_name1 ("." +++ EXTENSION_SYSTEM_DYNAMIC)
		= (True,file_name1,files);
	| ends file_name1 ("." +++ EXTENSION_USER_DYNAMIC)
		#! (ok,userFile,files)
			= fopen file_name1 FReadText files
		| not ok
			#! (_,files)
				= fclose userFile files;
			= (False,"",files)
		
		# (databaseFileName,userFile)
			= freadline userFile
		# databaseFileName
			= (%) databaseFileName (0,(size databaseFileName)-2) //for deleting the "\n".
		
		#! (_,files)
			= fclose userFile files;
		= (True,CONVERTED_ENCODED_DYNAMIC_FILE_NAME_INTO_PATH GetDynamicLinkerPath databaseFileName,files)

		= abort "get_system_dynamic_file: no user or system dynamic dropped";
